/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.AttackerActionWhenHitPower;
import io.github.apace100.origins.power.ClimbingPower;
import io.github.apace100.origins.power.EffectImmunityPower;
import io.github.apace100.origins.power.ModifyLavaSpeedPower;
import io.github.apace100.origins.power.ModifySwimSpeedPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.PreventDeathPower;
import io.github.apace100.origins.power.SelfActionOnHitPower;
import io.github.apace100.origins.power.SelfActionOnKillPower;
import io.github.apace100.origins.power.SelfActionWhenHitPower;
import io.github.apace100.origins.power.SetEntityGroupPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.power.TargetActionOnHitPower;
import io.github.apace100.origins.power.WalkOnFluidPower;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private Optional<BlockPos> field_233624_bE_;
    @Unique
    private float cachedDamageAmount;

    @Shadow
    protected abstract float func_175134_bD();

    @Shadow
    public abstract float func_70689_ay();

    @Shadow
    public abstract boolean func_230491_ea_();

    @Shadow
    public abstract void func_70606_j(float var1);

    public LivingEntityMixin(EntityType<?> type, World world) {
        super(type, world);
    }

    @Inject(method={"canWalkOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyWalkableFluids(Fluid fluid, CallbackInfoReturnable<Boolean> info) {
        if (OriginComponent.getPowers(this, WalkOnFluidPower.class).stream().anyMatch(p -> fluid.func_207185_a(p.getFluidTag()))) {
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN")})
    private void invokeHitActions(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            OriginComponent.getPowers(this, SelfActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            OriginComponent.getPowers(this, AttackerActionWhenHitPower.class).forEach(p -> p.whenHit(source, amount));
            OriginComponent.getPowers(source.func_76346_g(), SelfActionOnHitPower.class).forEach(p -> p.onHit((LivingEntity)this, source, amount));
            OriginComponent.getPowers(source.func_76346_g(), TargetActionOnHitPower.class).forEach(p -> p.onHit((LivingEntity)this, source, amount));
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;onDeath(Lnet/minecraft/entity/damage/DamageSource;)V")})
    private void invokeKillAction(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        OriginComponent.getPowers(source.func_76346_g(), SelfActionOnKillPower.class).forEach(p -> p.onKill((LivingEntity)this, source, amount));
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(doubleValue=0.5, ordinal=0), @Constant(doubleValue=0.5, ordinal=1), @Constant(doubleValue=0.5, ordinal=2)})
    private double modifyLavaSpeed(double original) {
        return OriginComponent.modify((Entity)this, ModifyLavaSpeedPower.class, original);
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isWet()Z"))
    private boolean preventExtinguishingFromSwimming(LivingEntity livingEntity) {
        if (OriginComponent.hasPower((Entity)livingEntity, SwimmingPower.class) && livingEntity.func_203007_ba() && !(this.func_233571_b_((ITag)FluidTags.field_206959_a) > 0.0)) {
            return false;
        }
        return livingEntity.func_203008_ap();
    }

    @Inject(at={@At(value="HEAD")}, method={"getGroup"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<CreatureAttribute> info) {
        OriginComponent component;
        List<SetEntityGroupPower> groups;
        if (this instanceof PlayerEntity && (groups = (component = ModComponentsArchitectury.getOriginComponent(this)).getPowers(SetEntityGroupPower.class)).size() > 0) {
            if (groups.size() > 1) {
                Origins.LOGGER.warn("Player " + this.func_145748_c_().toString() + " has two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)groups.get((int)0).group);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canHaveStatusEffect"}, cancellable=true)
    private void preventStatusEffects(EffectInstance effect, CallbackInfoReturnable<Boolean> info) {
        for (EffectImmunityPower power : OriginComponent.getPowers(this, EffectImmunityPower.class)) {
            if (!power.doesApply(effect)) continue;
            info.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isClimbing"}, cancellable=true)
    public void doSpiderClimbing(CallbackInfoReturnable<Boolean> info) {
        List<ClimbingPower> climbingPowers;
        if (!((Boolean)info.getReturnValue()).booleanValue() && this instanceof PlayerEntity && (climbingPowers = ModComponentsArchitectury.getOriginComponent(this).getPowers(ClimbingPower.class, true)).size() > 0) {
            if (climbingPowers.stream().anyMatch(Power::isActive)) {
                BlockPos pos = this.func_233580_cy_();
                this.field_233624_bE_ = Optional.of(pos);
                info.setReturnValue((Object)true);
            } else if (this.func_230491_ea_() && climbingPowers.stream().anyMatch(ClimbingPower::canHold)) {
                info.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBreatheInWater"}, cancellable=true)
    public void doWaterBreathing(CallbackInfoReturnable<Boolean> info) {
        if (PowerTypes.WATER_BREATHING.isActive(this)) {
            info.setReturnValue((Object)true);
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;updateVelocity(FLnet/minecraft/util/math/Vec3d;)V", ordinal=0))
    public void modifyUnderwaterMovementSpeed(LivingEntity livingEntity, float speedMultiplier, Vector3d movementInput) {
        livingEntity.func_213309_a(OriginComponent.modify((Entity)livingEntity, ModifySwimSpeedPower.class, speedMultiplier), movementInput);
    }

    @ModifyConstant(method={"swimUpward"}, constant={@Constant(doubleValue=0.03999999910593033)})
    public double modifyUpwardSwimming(double original) {
        return OriginComponent.modify((Entity)this, ModifySwimSpeedPower.class, original);
    }

    @ModifyConstant(method={"knockDownwards"}, constant={@Constant(doubleValue=-0.03999999910593033)})
    @OnlyIn(value=Dist.CLIENT)
    public double swimDown(double original) {
        return OriginComponent.modify((Entity)this, ModifySwimSpeedPower.class, original);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;method_26317(DZLnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"))
    public Vector3d method_26317Proxy(LivingEntity entity, double d, boolean bl, Vector3d vec3d) {
        Vector3d oldReturn = entity.func_233626_a_(d, bl, vec3d);
        if (PowerTypes.LIKE_WATER.isActive(this) && Math.abs(vec3d.field_72448_b - d / 16.0) < 0.025) {
            return new Vector3d(oldReturn.field_72450_a, 0.0, oldReturn.field_72449_c);
        }
        return entity.func_233626_a_(d, bl, vec3d);
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;tryUseTotem(Lnet/minecraft/entity/damage/DamageSource;)Z")})
    private void cacheDamageAmount(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.cachedDamageAmount = amount;
    }

    @Inject(method={"tryUseTotem"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Hand;values()[Lnet/minecraft/util/Hand;")}, cancellable=true)
    private void preventDeath(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Optional<PreventDeathPower> preventDeathPower = OriginComponent.getPowers(this, PreventDeathPower.class).stream().filter(p -> p.doesApply(source, this.cachedDamageAmount)).findFirst();
        if (preventDeathPower.isPresent()) {
            this.func_70606_j(1.0f);
            preventDeathPower.get().executeAction();
            cir.setReturnValue((Object)true);
        }
    }
}

